% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_mirror.R
\name{mc_mirror}
\alias{mc_mirror}
\title{Mirror files and directories using mc command}
\usage{
mc_mirror(
  from,
  to,
  overwrite = FALSE,
  remove = FALSE,
  flags = "",
  verbose = FALSE
)
}
\arguments{
\item{from}{Character string specifying the source file or directory path.}

\item{to}{Character string specifying the destination path.}

\item{overwrite}{Logical indicating whether to overwrite existing files.
Default is \code{FALSE}.}

\item{remove}{Logical indicating whether to remove extraneous files from
the destination. Default is \code{FALSE}.}

\item{flags}{Additional flags to be passed to the \code{mirror} command.
Default is an empty string.}

\item{verbose}{Logical indicating whether to display verbose output.
Default is \code{FALSE}.}
}
\value{
Returns the list from \code{\link[processx:run]{processx::run()}}, with components \code{status},
\code{stdout}, \code{stderr}, and \code{timeout}; invisibly.
}
\description{
This function uses the \code{mc} command to mirror files and directories
from one location to another.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Mirror files and directories from source to destination
mc_mirror("path/to/source", "path/to/destination")

# Mirror files and directories with overwrite and remove options
mc_mirror("path/to/source", "path/to/destination",
           overwrite = TRUE, remove = TRUE)

# Mirror files and directories with additional flags and verbose output
mc_mirror("path/to/source", "path/to/destination", 
          flags = "--exclude '*.txt'", verbose = TRUE)
\dontshow{\}) # examplesIf}
}
