\name{confint.mipfp}
\alias{confint.mipfp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Computing confidence intervals for the mipfp estimates
}
\description{
This function computes the (asymptotic) Wald confidence intervals at a given 
significance level for the estimates of an \code{mipfp} object generated by
\code{\link[mipfp:Estimate]{Estimate}}.
}
\usage{
\method{confint}{mipfp}(object, parm, level = 0.95, prop = FALSE, ...)
}
\arguments{
  \item{object}{
    The \code{mipfp} object containing the estimates.
}
  \item{parm}{
    A specification of which estimates are to be given confidence intervals, 
    either a vector of numbers or a vector of names. If missing, all estimates
    are considered.
}
  \item{level}{
    The confidence level required.
}
  \item{prop}{
    A boolean indicating if the results should be using counts (\code{FALSE}) or
    proportion (\code{TRUE}). Default is \code{FALSE}.
}
  \item{\dots}{
    Further arguments passed to or from other methods (for instance
    \code{\link[mipfp:vcov.mipfp]{vcov.mipfp}}).
}
}
\details{
The confidence interval of the estimates \eqn{\hat{X}}{X.hat}, at significance
level \eqn{\alpha}{\alpha} is given by
\deqn{\hat{X} \pm z \left( 1-\frac{\alpha}{2} \right) * 
\hat{\sigma}}{X.hat +/- z(1-\alpha/2) * \sigma.hat}
where \eqn{\hat{\sigma}}{\sigma.hat} is the standart deviations of 
\eqn{\hat{X}}{X.hat}, \eqn{z}{z} and 
\eqn{\alpha = 1 - level}{\alpha = 1 - level} is the inverse of the cumulative 
distribution function of the standard normal distribution.
}
\value{
  A matrix containing the upper and lower bounds for the estimated
  counts/probabilities (depending on the value of the \code{prop} argument).
}
\references{
 Smithson, M. (2002).
 \emph{Confidence intervals}.
 Sage Publications.
}
\author{
Johan Barthelemy.

Maintainer: Johan Barthelemy \email{johan@uow.edu.au}.
}
\seealso{
\code{\link[stats:confint.default]{confint}} for the default method to compute 
confidence intervals for model parameters.
\code{\link[mipfp:Estimate]{Estimate}}, \code{\link[mipfp:Ipfp]{Ipfp}} and 
\code{\link[mipfp:ObtainModelEstimates]{ObtainModelEstimates}} to generate the
\code{mipfp} objects for this function.
}
\examples{
# true contingency (2-way) table
true.table <- array(c(43, 44, 9, 4), dim = c(2, 2))
# generation of sample, i.e. the seed to be updated
seed <- ceiling(true.table / 10)
# desired targets (margins)
target.row <- apply(true.table, 2, sum)
target.col <- apply(true.table, 1, sum)
# storing the margins in a list
target.data <- list(target.col, target.row)
# list of dimensions of each marginal constrain
target.list <- list(1, 2)
# using ipfp
res <- Estimate(seed, target.list, target.data)
# computing and printing the confidence intervals
print(confint(res))
}
\concept{confidence interval}
\keyword{multivariate}