% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditionedProp.R
\name{conditionedProp}
\alias{conditionedProp}
\title{Compute Conditioned Proportions for UPs}
\usage{
conditionedProp(data, h, s, y, eh, es, ey)
}
\arguments{
\item{data}{A data.frame containing the characteristics of UPs.}

\item{h}{An integer representing the MP's hair color.}

\item{s}{An integer representing the MP's skin color.}

\item{y}{An integer representing the MP's eye color.}

\item{eh}{A numeric value representing the error rate for observing hair color.}

\item{es}{A numeric value representing the error rate for observing skin color.}

\item{ey}{A numeric value representing the error rate for observing eye color.}
}
\value{
A numeric vector containing the conditioned proportion (numerator) for each individual in the dataset.
These values are calculated based on the probability of observing the given combination
of characteristics in the MP, compared to each UP.
}
\description{
This function calculates the conditioned proportions
for pigmentation traits for UP, when UP is MP.
It considers error rates for observations
of hair color, skin color, and eye color.
}
