% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixcure.r
\name{plot.predict.mixcure}
\alias{plot.predict.mixcure}
\title{Plot method for the prediction of mixture cure models}
\usage{
\method{plot}{predict.mixcure}(
  x,
  type = "l",
  add = FALSE,
  which = 1:nrow(x$cure),
  curemark = FALSE,
  conditional = FALSE,
  xlab,
  ylab,
  ylim = c(0, 1),
  lty = seq(along = which),
  ...
)
}
\arguments{
\item{x}{an object from predict.mixcure}

\item{type}{line type. The default is type = "l"}

\item{add}{if add = FALSE (default), a plot is shown in a new graphics window.
Otherwise, an existing window is used.}

\item{which}{a vector of row numbers for which the survival probabilities
will be drawn. The default is to draw the survival probabilities for all
rows.}

\item{curemark}{if curemark = TRUE, a line will be drawn at a height that is
equal to the cure rate}

\item{conditional}{if conditional = FALSE (default), the unconditional
survival probabilities will be drawn. Otherwise, the survival probabilities
of uncured subjects will be drawn.}

\item{xlab}{the label for x axis}

\item{ylab}{the label for y axis}

\item{ylim}{the range for y axis}

\item{lty}{the line types for survival curves from different groups}

\item{\dots}{other standard graphics parameters can be set here.}
}
\value{
a graphics window will be opened and drawn.
}
\description{
Plot the predicted survival function curves from mixture cure models
}
\details{
This function plots survival probabilities for each row in newdata. The
survival probabilities can be conditional probabilities for uncured subjects
or unconditional survival probabilities, the latter will level off at
estimated cure rates.
}
\examples{

data(leukaemia)
plot(predict(mixcure(Surv(time, cens) ~ transplant, ~ transplant,
data = leukaemia), newdata = leukaemia[1, ], times = 0:2000))

}
\seealso{
mixcure predict.mixcure
}
\author{
Yingwei Peng
}
