% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsh.R
\name{lsh}
\alias{lsh}
\title{K-Approximate-Nearest-Neighbor Search with LSH}
\usage{
lsh(
  bucket_size = NA,
  hash_width = NA,
  input_model = NA,
  k = NA,
  num_probes = NA,
  projections = NA,
  query = NA,
  reference = NA,
  second_hash_size = NA,
  seed = NA,
  tables = NA,
  true_neighbors = NA,
  verbose = getOption("mlpack.verbose", FALSE)
)
}
\arguments{
\item{bucket_size}{The size of a bucket in the second level hash. 
Default value "500" (integer).}

\item{hash_width}{The hash width for the first-level hashing in the LSH
preprocessing. By default, the LSH class automatically estimates a hash
width for its use.  Default value "0" (numeric).}

\item{input_model}{Input LSH model (LSHSearch).}

\item{k}{Number of nearest neighbors to find.  Default value "0"
(integer).}

\item{num_probes}{Number of additional probes for multiprobe LSH; if 0,
traditional LSH is used.  Default value "0" (integer).}

\item{projections}{The number of hash functions for each tabl.  Default
value "10" (integer).}

\item{query}{Matrix containing query points (optional) (numeric
matrix).}

\item{reference}{Matrix containing the reference dataset (numeric
matrix).}

\item{second_hash_size}{The size of the second level hash table. 
Default value "99901" (integer).}

\item{seed}{Random seed.  If 0, 'std::time(NULL)' is used.  Default
value "0" (integer).}

\item{tables}{The number of hash tables to be used.  Default value "30"
(integer).}

\item{true_neighbors}{Matrix of true neighbors to compute recall with
(the recall is printed when -v is specified) (integer matrix).}

\item{verbose}{Display informational messages and the full list of
parameters and timers at the end of execution.  Default value
"getOption("mlpack.verbose", FALSE)" (logical).}
}
\value{
A list with several components:
\item{distances}{Matrix to output distances into (numeric matrix).}
\item{neighbors}{Matrix to output neighbors into (integer matrix).}
\item{output_model}{Output for trained LSH model (LSHSearch).}
}
\description{
An implementation of approximate k-nearest-neighbor search with
locality-sensitive hashing (LSH).  Given a set of reference points and a set
of query points, this will compute the k approximate nearest neighbors of
each query point in the reference set; models can be saved for future use.
}
\details{
This program will calculate the k approximate-nearest-neighbors of a set of
points using locality-sensitive hashing. You may specify a separate set of
reference points and query points, or just a reference set which will be used
as both the reference and query set.
}
\examples{
# For example, the following will return 5 neighbors from the data for each
# point in "input" and store the distances in "distances" and the neighbors
# in "neighbors":

\dontrun{
output <- lsh(k=5, reference=input)
distances <- output$distances
neighbors <- output$neighbors
}

# The output is organized such that row i and column j in the neighbors
# output corresponds to the index of the point in the reference set which is
# the j'th nearest neighbor from the point in the query set with index i. 
# Row j and column i in the distances output file corresponds to the distance
# between those two points.
# 
# Because this is approximate-nearest-neighbors search, results may be
# different from run to run.  Thus, the "seed" parameter can be specified to
# set the random seed.
# 
# This program also has many other parameters to control its functionality;
# see the parameter-specific documentation for more information.
}
\author{
mlpack developers
}
