% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTPRandFPRbyThreshold.r
\name{getTPRandFPRbyThreshold}
\alias{getTPRandFPRbyThreshold}
\title{Estimates true and false positive rates}
\usage{
getTPRandFPRbyThreshold(validation_scores, label_pos = 1, thr_range = seq(0,1,0.01))
}
\arguments{
\item{validation_scores}{\code{data.frame} scores estimated from the training set.
It should be comprised of three columns (1. positive scores; 2. negative
scores; 3.class).}

\item{label_pos}{numeric value or factor indicating the positive label.}

\item{thr_range}{a numerical \code{vector} of thresholds, ranged between 0 and 1. Default:
\code{seq(0.01,0.99,0.01)}.}
}
\value{
\code{data.frame} where each row has both (\code{tpr} and \code{fpr}) rates for
each threshold value. This function varies the threshold from 0.01 to 0.99 with
increments 0.01.
}
\description{
This function provides the true and false positive rates (\code{tpr} and \code{fpr}) for a range of thresholds.
}
\examples{
library(randomForest)
library(caret)
cv <- createFolds(aeAegypti$class, 2)
tr <- aeAegypti[cv$Fold1,]
validation <- aeAegypti[cv$Fold2,]
scorer <- randomForest(class~., data=tr, ntree=500)
scores <- cbind(predict(scorer, validation, type = c("prob")), validation$class)
TprFpr <- getTPRandFPRbyThreshold(scores)
}
\author{
Everton Cherman <evertoncherman@gmail.com>

Andre Maletzke <andregustavom@gmail.com>
}
