
#' @importFrom utils bibentry

bibentries = c(
  greenwell_simple_2018 = bibentry("techreport",
    title = "A Simple and Effective Model-Based Variable Importance Measure",
    url = "http://arxiv.org/abs/1805.04755",
    institution = "arXiv preprint",
    author = "Greenwell, Brandon M. and Boehmke, Bradley C. and McCarthy, Andrew J.",
    year = "2018",
    note = "arXiv:1805.04755"
  ),
  fisher_all_2019 = bibentry("inproceedings",
    title = "All Models are Wrong, but Many are Useful: Learning a Variable's Importance by Studying an Entire Class of Prediction Models Simultaneously",
    author = "Lundberg, Scott M. and Lee, Su-In",
    title = "A unified approach to interpreting model predictions",
    year = "2017",
    isbn = "9781510860964",
    publisher = "Curran Associates Inc.",
    address = "Red Hook, NY, USA",
    abstract = "Understanding why a model makes a certain prediction can be as crucial as the prediction's accuracy in many applications. However, the highest accuracy for large modern datasets is often achieved by complex models that even experts struggle to interpret, such as ensemble or deep learning models, creating a tension between accuracy and interpretability. In response, various methods have recently been proposed to help users interpret the predictions of complex models, but it is often unclear how these methods are related and when one method is preferable over another. To address this problem, we present a unified framework for interpreting predictions, SHAP (SHapley Additive exPlanations). SHAP assigns each feature an importance value for a particular prediction. Its novel components include: (1) the identification of a new class of additive feature importance measures, and (2) theoretical results showing there is a unique solution in this class with a set of desirable properties. The new class unifies six existing methods, notable because several recent methods in the class lack the proposed desirable properties. Based on insights from this unification, we present new methods that show improved computational performance and/or better consistency with human intuition than previous approaches.",
    booktitle = "Proceedings of the 31st International Conference on Neural Information Processing Systems",
    pages = "4768--4777",
    numpages = "10",
    location = "Long Beach, California, USA",
    series = "NIPS'17"
  ), breiman_leo_random_2001 = bibentry("article",
    title = "Random Forest",
    volume = "45",
    number = "1",
    journal = "Machine Learning",
    author = "Breiman, Leo",
    year = "2001",
    pages = "5--32",
  ), molnar_complexity_2020 = bibentry("inbook",
    title = "Quantifying Model Complexity via Functional Decomposition for Better Post-hoc Interpretability",
    chapter = "1",
    booktitle = "Communications in Computer and Information Science",
    publisher = "Springer International Publishing",
    author = "Molnar,  Christoph and Casalicchio,  Giuseppe and Bischl,  Bernd",
    year = "2020",
    pages = "193--204"
  ), friedman_pdp_2001 = bibentry("article",
    title = "Greedy Function Approximation: A Gradient Boosting Machine",
    volume = "29",
    number = "5",
    journal = "The Annals of Statistics",
    publisher = "Institute of Mathematical Statistics",
    author = "Friedman,  Jerome H.",
    year = "2001"
  ), apley_ale_2020 = bibentry("article",
    author = "Apley, Daniel W. and Zhu, Jingyu",
    title = "Visualizing the Effects of Predictor Variables in Black Box Supervised Learning Models",
    journal = "Journal of the Royal Statistical Society Series B: Statistical Methodology",
    volume = "82",
    number = "4",
    pages = "1059-1086",
    year = "2020"
  ), mehrabi_fairness_2022 = bibentry("article",
    author = "Mehrabi, Ninareh and Morstatter, Fred and Saxena, Nripsuta and Lerman, Kristina and Galstyan, Aram",
    title = "A Survey on Bias and Fairness in Machine Learning",
    year = "2021",
    publisher = "Association for Computing Machinery",
    address = "New York, NY, USA",
    volume = "54",
    number = "6",
    journal = "ACM Computational Surveys",
    articleno = "115",
    numpages = "35",
  ), creditdata = bibentry("article",
    url = "https://archive.ics.uci.edu/dataset/144/statlog+german+credit+data",
    author = "Hofmann,  Hans",
    title = "Statlog ({G}erman Credit Data)",
    journal = "{UCI} Machine Learning Repository",
    year = "1994"
  ), kaggle16 = bibentry("misc",
    author = "Leonardo Ferreira",
    editor = "Kaggle Inc.",
    title = "{G}erman credit risk",
    url = "https://www.kaggle.com/datasets/kabure/german-credit-data-with-risk",
    year = "2018",
    note = "Last accessed 10.04.2024"
  ), mlr3book = bibentry("book",
    title = "Applied machine learning using mlr3 in R",
    ISBN = "9781003402848",
    publisher = "Chapman and Hall/CRC",
    author = "Bischl,  Bernd and Sonabend,  Raphael and Kotthoff,  Lars and Lang,  Michel",
    url = "https://mlr3book.mlr-org.com/",
    year = "2024",
    )
)
