% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes.R
\name{bayesComputeMarginalFactor}
\alias{bayesComputeMarginalFactor}
\title{Compute a marginal factor (continuous or discrete random variable).}
\usage{
bayesComputeMarginalFactor(df, feature, doEcdf = FALSE)
}
\arguments{
\item{df}{data.frame that contains all the feature's data}

\item{feature}{data.frame containing the designated feature as created
by @seealso \code{mmb::createFeatureForBayes()}.}

\item{doEcdf}{default FALSE a boolean to indicate whether to use the
empirical CDF to return a probability when inferencing a continuous
feature. If false, uses the empirical PDF to return the rel. likelihood.
This parameter does not have any effect when inferring discrete values.
Using the ECDF, a probability to find a value less than or equal to the
given value is returned.}
}
\value{
numeric the probability or likelihood of the given feature
assuming its given value.
}
\description{
Computes the probability (discrete feature) or relative likelihood
(continuous feature) of one given feature and a concrete value for it.
}
\examples{
feat <- mmb::createFeatureForBayes(
  name = "Petal.Length", value = mean(iris$Petal.Length))
mmb::bayesComputeMarginalFactor(df = iris, feature = feat)
mmb::bayesComputeMarginalFactor(df = iris, feature = feat, doEcdf = TRUE)
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
