% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfAndProb.R
\name{estimatePdf}
\alias{estimatePdf}
\title{Safe PDF estimation that works also for sparse random variables.}
\usage{
estimatePdf(
  data = c(),
  densFun = function(vec) {     stats::density(vec, bw = "SJ") }
)
}
\arguments{
\item{data}{vector of numeric data. Used to compute the empirical density
of the data.}

\item{densFun}{function default \code{stats::density} with bandwith 'SJ'.
Function to compute the empirical density of a non-empty vector of numerical
data. Note that this function needs to return the properties 'x' and 'y' as
\code{stats::density} does, so that we can return the argmax.}
}
\value{
list with a function that is the empirical PDF using KDE. The list
also has two properties 'min' and 'max' which represent the integratable
range of that function. 'min' and 'max' are both zero if not data (an
empty vector) was given. If one data point was given, then they correspond
to its value -/+ \code{.Machine$double.eps}. The list further contains two
numeric vectors 'x' and 'y', and a property 'argmax'. If no data was given,
'x' and 'y' are zero, and 'argmax' is NA. If one data points was given,
then 'x' and 'argmax' equal it, and 'y' is set to 1. If two or more data
points given, then the empirical density is estimated and 'x' and y' are
filled from its estimate. 'argmax' is then set to that 'x', where 'y'
becomes max.
}
\description{
Given a few observations of a random variable, this function
returns an approximation of the PDF as a function. Returns also the PDF's
support and argmax and works when only zero or one value was given. Depending
on the used density function, two values are often enough to estimate a PDF.
}
\note{
If the given vector is empty, warns and returns a constant function
that always returns zero for all values.

If the given vector contains only one observation, then a function
is returned that returns 1 iff the value supplied is the same as the
observation. Otherwise, that function will return zero.
}
\examples{
epdf <- mmb::estimatePdf(data = iris$Petal.Width)
print(epdf$argmax)
plot(epdf)

# Get relative likelihood of some values:
epdf$fun(0.5)
epdf$fun(1.7)
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
\keyword{density-estimation}
\keyword{likelihood}
