% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesisTesting.R
\name{getHypothesisTest}
\alias{getHypothesisTest}
\title{Hypothesis Test for Two Mobility Datasets}
\usage{
getHypothesisTest(
  dat_A,
  dat_B,
  cols_A,
  cols_B,
  type,
  indices = "all",
  num_ranks,
  exclude_value,
  bounds,
  rerank_exclude_value = FALSE,
  strict = TRUE,
  bootstrap_iter = 100
)
}
\arguments{
\item{dat_A}{a dataframe with an "id" column}

\item{dat_B}{a dataframe with an "id" column}

\item{cols_A}{a list of character strings denoting the first and second column
to be used in the index calculations for dat_A}

\item{cols_B}{a list of character strings denoting the first and second column
to be used in the index calculations for dat_B}

\item{type}{a character string indicating the type of ranking;
accepts 'relative', 'mixed', and 'absolute'}

\item{indices}{a vector of character strings indicating which mobility indices are desired;
currently support 'prais_bibby', 'average_movement', 'wgm', and 'origin_specific'.
The default value is 'all'.}

\item{num_ranks}{an integer specifying the number of ranks for a relative or mixed ranking}

\item{exclude_value}{a single numeric value that is excluded in calculating the transition matrix;
see the rerank_exclude_value parameter to specify how the exclude value is handled}

\item{bounds}{a sequence of numeric bounds for defining absolute ranks}

\item{rerank_exclude_value}{a character string indicating how the exclude value is handled when present; accepts
'as_new_rank', 'as_existing_rank', and 'exclude'}

\item{strict}{logical. If TRUE, indices are calculated from the given values. If FALSE,
indices are calculated by jittering the values to ensure uniqueness of bounds of ranks.
Only used with relative and mixed types. The default value is TRUE.}

\item{bootstrap_iter}{the number of bootstrap iterations used to estimate hypothesis tests.
The default value is 100.}
}
\value{
Returns a named vector containing the estimated probabilities that index value for dataset A is greater than the corresponding index value for dataset B
}
\description{
Calculates hypothesis tests of mobility indices from two datasets.
Specifically, for datasets A and B, this function performs one-sided nonparametric hypothesis tests
that the index value for A is greater than the corresponding index value for B.
Supports Prais-Bibby, Absolute Movement, Origin Specific, and Weighted Group Mobility indices and relative, mixed,
and absolute types of rankings in the calculation these indices.
}
\examples{
getHypothesisTest(dat_A = incomeMobility,
                  dat_B = incomeMobility,
                  cols_A = c("t0", "t3"),
                  cols_B = c("t5", "t8"),
                  type = "relative",
                  num_ranks = 5)
}
