% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod09nrt.R
\name{check_for_matching_geolocation_files_mod09nrt}
\alias{check_for_matching_geolocation_files_mod09nrt}
\title{Checks that every MODIS surface reflectance project HDF has a matching MOD03 file}
\usage{
check_for_matching_geolocation_files_mod09nrt(moddir = getwd(),
  modtxt = "MOD09", geoloctxt = "MOD03", return_geoloc = FALSE,
  return_product = FALSE)
}
\arguments{
\item{moddir}{the string describing the directory containing the MOD09 and MOD03 files; both must be in the same directory.  Default: getwd(), which gives the present working directory.}

\item{modtxt}{the text string indicating which HDF files are the MODIS surface reflectance product (or hypothetically, other product). Default: MOD09 (MODIS surface reflectance product)}

\item{geoloctxt}{the text string indicating which HDF files are the MODIS geolocation files (or hypothetically, another set of files). Default: MOD03}

\item{return_geoloc}{if TRUE, return the list of unmatched geolocation files (e.g. MOD03 )}

\item{return_product}{if TRUE, return the list of unmatched product files (e.g. MOD09)}
}
\value{
data.frame of matching files; or a list of non-matching files, if \code{return_geoloc} or \code{return_product} are TRUE.
}
\description{
Each MOD09 surface reflectance product file requires a corresponding
MOD03 geolocation file to be successfully processed with the MRTSwath tool.
}
\details{
MRTSwath is the MRT (MODIS Reprojection Tool) for the MODIS

E.g. this surface reflectance file:

MOD09.A2016204.0500.005.2016204062219.NRT.hdf

...goes with this corresponding geolocation file:

MOD03.A2016204.0500.005.2016204060250.NRT.hdf

...which is a large file (~30 MB) containing detailed information
on the position, tilt, etc. of the MODIS satellite.
MRTSwath tool needs one of each, however.
}
\examples{
# Check your working directory
moddir = getwd()

# Here are some example MODIS files in mod09nrt/extdata/
# Code excluded from CRAN check because it depends on modiscdata
\dontrun{
library(devtools)
library(modiscdata)
moddir = system.file("extdata/2002raw/", package="modiscdata")

# You need to have some e.g. MOD files in it (from the MODIS-TERRA platform)
list.files(path=moddir, pattern="MOD")
list.files(path=moddir, pattern="MOD")

# Check for matches (for MODIS-TERRA platform)
check_for_matching_geolocation_files_mod09nrt(moddir=moddir, modtxt="MOD09", geoloctxt="MOD03", 
return_geoloc=FALSE, return_product=FALSE)
}

}
\author{
Rishabh Gupta \email{rishabh.uk@gmail.com}
}


