% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_update_observations.R
\name{ms_update_observations}
\alias{ms_update_observations}
\title{Update the observations of a modelStudio object}
\usage{
ms_update_observations(
  object,
  explainer,
  new_observation = NULL,
  new_observation_y = NULL,
  max_features = 10,
  B = 10,
  show_info = TRUE,
  parallel = FALSE,
  widget_id = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{modelStudio} created with \code{modelStudio()}.}

\item{explainer}{An \code{explainer} created with \code{DALEX::explain()}.}

\item{new_observation}{New observations with columns that correspond to variables used in the model.}

\item{new_observation_y}{True label for \code{new_observation} (optional).}

\item{max_features}{Maximum number of features to be included in BD and SV plots.
Default is \code{10}.}

\item{B}{Number of permutation rounds used for calculation of SV and FI.
Default is \code{10}.
See \href{https://modelstudio.drwhy.ai/articles/ms-perks-features.html#more-calculations-means-more-time}{\bold{vignette}}}

\item{show_info}{Verbose a progress on the console. Default is \code{TRUE}.}

\item{parallel}{Speed up the computation using \code{parallelMap::parallelMap()}.
See \href{https://modelstudio.drwhy.ai/articles/ms-perks-features.html#parallel-computation}{\bold{vignette}}.
This might interfere with showing progress using \code{show_info}.}

\item{widget_id}{Use an explicit element ID for the widget (rather than an automatically generated one).
Useful e.g. when using \code{modelStudio} with Shiny.
See \href{https://modelstudio.drwhy.ai/articles/ms-perks-features.html#shiny-1}{\bold{vignette}}.}

\item{overwrite}{Overwrite existing observations and their explanations.
Default is \code{FALSE} which means add new observations to the existing ones.}

\item{...}{Other parameters.}
}
\value{
An object of the \code{r2d3, htmlwidget, modelStudio} class.
}
\description{
This function calculates local explanations on new observations and adds them
to the \code{modelStudio} object.
}
\examples{
library("DALEX")
library("modelStudio")

# fit a model
model_titanic <- glm(survived ~., data = titanic_imputed, family = "binomial")

# create an explainer for the model
explainer_titanic <- explain(model_titanic,
                             data = titanic_imputed,
                             y = titanic_imputed$survived)

# make a studio for the model
ms <- modelStudio(explainer_titanic,
                  N = 200,  B = 5) # faster example

\donttest{

# add new observations
ms <- ms_update_observations(ms,
                             explainer_titanic,
                             new_observation = titanic_imputed[100:101,],
                             new_observation_y = titanic_imputed$survived[100:101])
ms



# overwrite the observations with new ones
ms <- ms_update_observations(ms,
                             explainer_titanic,
                             new_observation = titanic_imputed[100:101,],
                             overwrite = TRUE)
ms

}

}
\references{
\itemize{
  \item The input object is implemented in \href{https://modeloriented.github.io/DALEX/}{\bold{DALEX}}
  \item Feature Importance, Ceteris Paribus, Partial Dependence and Accumulated Dependence explanations
   are implemented in \href{https://modeloriented.github.io/ingredients/}{\bold{ingredients}}
  \item Break Down and Shapley Values explanations are implemented in
   \href{https://modeloriented.github.io/iBreakDown/}{\bold{iBreakDown}}
}
}
\seealso{
Vignettes: \href{https://modelstudio.drwhy.ai/articles/ms-r-python-examples.html}{\bold{modelStudio - R & Python examples}}
and \href{https://modelstudio.drwhy.ai/articles/ms-perks-features.html}{\bold{modelStudio - perks and features}}
}
