% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{early_january_2023_weather}
\alias{early_january_2023_weather}
\title{Early January hourly weather data for 2023}
\format{
A data frame of 360 rows representing hourly measurements and 15 variables
\describe{
\item{origin}{Weather station. Named \code{origin} to facilitate merging with
\code{\link[nycflights23:flights]{nycflights23::flights}} data.}
\item{year, month, day, hour}{Time of recording.}
\item{temp, dewp}{Temperature and dewpoint in F.}
\item{humid}{Relative humidity.}
\item{wind_dir, wind_speed, wind_gust}{Wind direction (in degrees), speed
and gust speed (in mph).}
\item{precip}{Precipitation, in inches.}
\item{pressure}{Sea level pressure in millibars.}
\item{visib}{Visibility in miles.}
\item{time_hour}{Date and hour of the recording as a \code{POSIXct} date.}
}
}
\source{
ASOS download from Iowa Environmental Mesonet,
\url{https://mesonet.agron.iastate.edu/request/download.phtml}.
}
\usage{
early_january_2023_weather
}
\description{
Hourly meteorological data for LGA, JFK and EWR for the month of January 2023.
This is a subset of the \code{weather} data frame from \code{nycflights23}.
}
\seealso{
\code{\link[nycflights23:weather]{nycflights23::weather}}.
}
\keyword{datasets}
