% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{spotify_52_shuffled}
\alias{spotify_52_shuffled}
\title{Spotify 52-Track Sample Dataset with 'popular or not' shuffled}
\format{
A data frame with 52 rows and 6 columns:
\describe{
\item{track_id}{\code{character}. Spotify ID for the track. See: \url{https://developer.spotify.com/documentation/web-api/}}
\item{track_genre}{\code{character}. Genre of the track, either "deep-house" or "metal".}
\item{artists}{\code{character}. Names of the artists associated with the track.}
\item{track_name}{\code{character}. Name of the track.}
\item{popularity}{\code{numeric}. Popularity score of the track (0-100). See: \url{https://developer.spotify.com/documentation/web-api/reference/#/operations/get-track}}
\item{popular_or_not}{\code{character}. A shuffled version of the column of the same name in the \code{spotify_52_original} data frame.}
}
}
\source{
\url{https://developer.spotify.com/documentation/web-api/}
}
\usage{
spotify_52_shuffled
}
\description{
This dataset contains a sample of 52 tracks from Spotify, focusing on two genres: deep-house and metal. It includes metadata about the tracks, the artists, and a shuffled indicator of whether each track is considered popular.
}
\examples{
data(spotify_52_shuffled)
head(spotify_52_shuffled)
}
\keyword{datasets}
