% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meshClip.R
\name{meshClip}
\alias{meshClip}
\title{Split a mesh by a plane into two meshes}
\usage{
meshClip(plyFile, A, B, C, D)
}
\arguments{
\item{plyFile}{An rgl \code{mesh3d} object to be clipped.}

\item{A, B, C, D}{Numeric coefficients of the clipping plane
(plane equation: \code{A*x + B*y + C*z + D = 0}).}
}
\value{
A list with two elements:
\describe{
\item{\code{meshA}}{The submesh on the side where \code{A*x + B*y + C*z + D >= 0}.}
\item{\code{meshB}}{The complementary submesh (may be \code{NULL} if empty).}
}
}
\description{
Internal utility that clips an rgl mesh3d by a plane defined as
A\emph{x + B}y + C*z + D = 0, returning the two resulting meshes.
}
\keyword{internal}
