% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hbe.R
\name{hbe}
\alias{hbe}
\title{Hall-Buckley-Eagleson method}
\usage{
hbe(coeff, x)
}
\arguments{
\item{coeff}{The coefficient vector. All values must be greater than 0.}

\item{x}{The vector of quantile values. All values must be greater than 0.}
}
\description{
Computes the cdf of a positively-weighted sum of chi-squared random variables with the Hall-Buckley-Eagleson (HBE) method.
}
\examples{
#Examples taken from Table 18.6 in N. L. Johnson, S. Kotz, N. Balakrishnan.
#Continuous Univariate Distributions, Volume 1, John Wiley & Sons, 1994.

hbe(c(1.5, 1.5, 0.5, 0.5), 10.203)            # should give value close to 0.95
hbe(coeff=c(1.5, 1.5, 0.5, 0.5), x=10.203)    # specifying parameters
hbe(c(1.5, 1.5, 0.5, 0.5), c(0.627, 10.203))  # x is a vector, output approx. 0.05, 0.95
}
\references{
\itemize{
  \item P. Hall. Chi squared approximations to the distribution of a sum of independent random variables. \emph{The Annals of Probability}, 11(4):1028-1036, 1983.
  \item M. J. Buckley and G. K. Eagleson. An approximation to the distribution of quadratic forms in normal random variables. \emph{Australian Journal of Statistics}, 30(1):150-159, 1988.
}
}
\keyword{distribution}

