% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_category.R
\name{question_category}
\alias{question_category}
\title{\code{question_category} S3 class}
\usage{
question_category(
  category = "Default category",
  first_question_number = 1,
  copyright = "",
  license = "",
  correct_feedback = "Correct.",
  partially_correct_feedback = "Partially correct.",
  incorrect_feedback = "Incorrect.",
  adapt_images = FALSE,
  width = 800,
  height = 600,
  author = "",
  fraction = 0
)
}
\arguments{
\item{category}{A string, category name.}

\item{first_question_number}{An integer, first number to compose the question
names.}

\item{copyright}{A string, copyright text to be included in each question that
is defined.}

\item{license}{A string, license text to be included in each question that is
defined.}

\item{correct_feedback}{A string, feedback on correct answers to each question.}

\item{partially_correct_feedback}{A string, feedback on partially correct answers
to each question.}

\item{incorrect_feedback}{A string, feedback on incorrect answers to each question.}

\item{adapt_images}{A boolean, adapt the images so that they are a similar size.}

\item{width}{A integer, width of each image.}

\item{height}{A integer, height of each image.}

\item{author}{A string, author name to be included in each question that is
defined.}

\item{fraction}{A number between 0 and 1.}
}
\value{
A \code{question_category} object.
}
\description{
Creates a \code{question_category} object.
}
\details{
Defines a category of questions to be included in the \emph{Moodle} question bank.

It allows us to define the name of the category, the copyright and license
literals that will be added to each question, and the feedback literals for
correct, partially correct and incorrect questions.

Each question can include an image after the text. We can also configure if
we want to automatically transform the images so that they have a standard
size that we can also indicate.

The \code{fraction} attribute is used in various question types to determine how a
specific answer impacts the question's score. Specifically, for incorrect answers
in the \code{multichoice} and \code{truefalse} types, the value calculated by dividing
\code{fraction} by the number of incorrect answers available is considered as the
amount deducted in case of an incorrect response.
}
\examples{

qc <- question_category(category = 'Initial test')

}
\seealso{
Other question definition functions: 
\code{\link{define_extended_question}()},
\code{\link{define_question}()},
\code{\link{define_questions_from_csv}()},
\code{\link{define_questions_from_data_frame}()},
\code{\link{define_questions_from_excel}()},
\code{\link{generate_xml}()},
\code{\link{generate_xml_file}()}
}
\concept{question definition functions}
