% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mycph.R
\name{extractHR}
\alias{extractHR}
\title{Extract hazard ratio from a data.frame}
\usage{
extractHR(x, digits = 2)
}
\arguments{
\item{x}{an object of class coxph}

\item{digits}{An integer indicating the number of decimal places (round) or
significant digits to be used. Default value is 2.}
}
\value{
a data.frame consist of hazard ratio and 95% confidence intervals and
        the p values.
}
\description{
Extract hazard ratio from a data.frame
}
\examples{
require(survival)
data(cancer)
fit=coxph(Surv(time,status)~age+sex+obstruct+perfor,data=colon)
extractHR(fit)
}
