% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_categories.R
\name{random.cat}
\alias{random.cat}
\alias{random.cat.apply}
\title{Generation of random age ranges}
\usage{
random.cat(n_cat = 20, min_age = 15, max_cat_low = 60, max_age = 74)

random.cat.apply(x, age, age_ranges, from, to)
}
\arguments{
\item{n_cat}{numeric. Number of categories, default: 20.}

\item{min_age}{numeric. Minimum age, default: 15.}

\item{max_cat_low}{numeric. Lower boundary of highest age categoriy, default: 60.}

\item{max_age}{numeric. Maximum age, default: 74.}

\item{x}{a data.frame with individual absolute ages.}

\item{age}{the column containing the individual absolute ages.}

\item{age_ranges}{a data.frame with age ranges.}

\item{from}{numeric. Column name for the begin of an age range.}

\item{to}{numeric. Column name for the end of an age range.}
}
\value{
One data.frame with the following items:

\itemize{
  \item \bold{from}:  Lower boundary of age category.
  \item \bold{to}: Upper boundary of age category.
 }

The original data.frame \code{x} with two additional columns:

\itemize{
  \item \bold{from}:  Lower boundary of age category.
  \item \bold{to}: Upper boundary of age category.
 }
}
\description{
Helper function that generates random age categories of absolute ages.
It is mainly used together with the functions \code{pop.sim.gomp}
and \code{random.cat.apply}. It will run until the number of categories
are reached \emph{and} there are no gaps in the sequence left.

Helper function that applies random age categories to "known" absolute ages.
It is mainly used together with the functions \code{pop.sim.gomp}
and \code{random.cat}.
}
\examples{
sim_ranges <- random.cat()

# Simulate population and age ranges first
pop_sim <- pop.sim.gomp(n = 10000)
sim_ranges <- random.cat()

# apply random age categories to simulated ages
sim_appl <- random.cat.apply(pop_sim$result, age = "age",
age_ranges = sim_ranges, from = "from", to = "to")
}
