% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mo_unif}
\alias{mo_unif}
\title{Moments of Order Statistics from the Uniform Distribution}
\usage{
mo_unif(r, n, k = 1, a = 0, b = 1)
}
\arguments{
\item{r}{rank(s) of the desired order statistic(s) (e.g., \code{1} for the smallest order statistic).}

\item{n}{sample size from which the order statistic is derived.}

\item{k}{order of the moment to compute (default is \code{1}).}

\item{a, b}{lower and upper limits of the distribution. Must be finite.}
}
\value{
The \eqn{k}th moment of the \eqn{r}th order statistic from a uniform distribution.
}
\description{
This function computes the moments of order statistics for the uniform distribution
based on the relationship described by Arnold and Balakrishnan (2012).
}
\details{
The function calculates the \eqn{k}th moment based on the formula:
\deqn{\text{E}[U_{r,n}^k] = \frac{B(k + r, n - r + 1)}{B(r, n - r + 1)},}
where \eqn{B(a, b)} is the complete beta function. When \eqn{a \neq 0} or \eqn{b \neq 1},
the transformation \eqn{U^* = a + (b - a)U} is used.
}
\examples{
# Example 1: First moment (mean) of the 2nd order statistic from a sample of size 5
mo_unif(2, 5, k = 1, a = 0, b = 1)

# Example 2: Second moment of the 3rd order statistic from a uniform distribution on [2, 5]
mo_unif(3, 7, k = 2, a = 2, b = 5)

}
\references{
Arnold, B. C., & Balakrishnan, N. (2012). \emph{Relations, bounds and approximations for
order statistics} (Vol. 53). Springer Science & Business Media.
}
