% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{inequality_constraint}
\alias{inequality_constraint}
\alias{equality_constraint}
\title{Graphics for constraints}
\usage{
inequality_constraint(
  previous = NULL,
  tilde,
  domain,
  npts = 100,
  fill = "blue",
  alpha = 1
)

equality_constraint(
  previous = NULL,
  tilde,
  domain,
  npts = 100,
  fill = "blue",
  alpha = 1
)
}
\arguments{
\item{previous}{can be ignored by user. It supports the pipe syntax for layering
graphics.}

\item{tilde}{a tilde expression specifying the constraint. For an inequality constraint
this should be a logical expression that is TRUE where the constraint is satisfied.
For an equality constraint, the left-hand side of the tilde expression should
be zero where the constraint IS satisfied.}

\item{domain}{as in contour_plot(), the domain over which to graph the constraint}

\item{npts}{a number specifying how finely to divide the domain in each direction. Default
is 100, but this gives a discernably pixelated appearance to the shading.  200 or 300
is more appropriate for publication-quality graphics.}

\item{fill}{the color to use for shading}

\item{alpha}{the opacity of the shading}
}
\value{
ggplot2 graphics layers
}
\description{
These functions are intended to annotate contour plots with constraint regions. Inequality
constraints are shaded where the constraint is NOT satisfied. Equality constraints
are shaded in a small region near where the constraint is satisfied.
}
\examples{
inequality_constraint(x + y > 2 ~ y + x, domain(y=0:3, x=0:2))
equality_constraint(x + y - 2 ~ y + x, domain(y=0:3, x=0:2), npts=200, alpha=.3, fill="red")

}
