% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_plot.R
\name{slice_plot}
\alias{slice_plot}
\title{Plot a function of a single variable}
\usage{
slice_plot(
  ...,
  npts = 101,
  color = "black",
  alpha = 1,
  label_text = "",
  label_x = 1,
  label_vjust = "top",
  label_color = color,
  label_alpha = alpha,
  singularities = numeric(0)
)
}
\arguments{
\item{\dots}{Canonical first three argument: \verb{[gg]}, tilde expression, \verb{[domain]} as well
as any parameters to be assigned or re-assigned.}

\item{npts}{Integer, number of points at which to evaluate the function.}

\item{color}{Color of curve}

\item{alpha}{Alpha of curve}

\item{label_text}{character string label to place near the graph curve. Default: none.}

\item{label_x}{number between 0 and 1 indicating the horizontal placement  of the \code{label_text}.}

\item{label_vjust}{vertical justification of label. One of "left", "middle", "right", "bottom", "center", "top", "inward", or "outward"}

\item{label_color}{color of label}

\item{label_alpha}{alpha of label}

\item{singularities}{numeric vector of x positions at which to break
the graph.

Additional arguments will be passed to \code{geom_line()}. Use, e.g. \code{color="red"}}
}
\value{
ggplot2 layers
}
\description{
In a slice plot, there  is one independent variable. The graph
shows the output of the function versus the independent variable. It's
called a slice plot to distinguish it from a contour plot, in which
the graph has one axis for each independent variable and the output
of the function is shown by color and labels.
}
\examples{
\dontrun{
slice_plot(sin(x) ~ x, domain(x = range(-5, 15)))
f <- makeFun(sin(2*pi*t/P) ~ t)
slice_plot(f(t, P=20) ~ t, domain(t = -5:10), label_text = "Period 20", label_x=0.9)
slice_plot(x^2 ~ x) # Error: no domain specified
slice_plot(cos(x) ~ x, domain(x[-10:10]) # domain will be -10 < x < 10
# see domain
}

}
