% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_plot.R
\name{surface_plot}
\alias{surface_plot}
\alias{interactive_plot}
\alias{surface_with_contours}
\title{Make an interactive plotly plot of a function of two variables}
\usage{
surface_plot(
  formula,
  domain = c(-5, 5),
  npts = 50,
  type = c("both", "surface", "contour", "heatmap")
)

interactive_plot(
  formula,
  domain = c(-5, 5),
  npts = 50,
  type = c("both", "surface", "contour", "heatmap")
)

surface_with_contours(formula, domain = c(-5, 5), npts = 50)
}
\arguments{
\item{formula}{a formula describing a function in  the manner
of \code{mosaicCalc::makeFun()}}

\item{domain}{a call to the \code{domain()} function giving ranges
using the same independent variables as in the \code{formula}}

\item{npts}{The fineness at which to evaluate the function specified
by the formula in the  plot. Default: 50}

\item{type}{Plot type: \code{"surface"},  \code{"contour"}, \code{"both"}, or \code{"heatmap"}}
}
\description{
An interactive plot lets you interrogate the plot to get
numerical values at each point. When \code{type = "surface"}, the
plot can be rotated to see the "shape" of the function from
various perspectives. Using the  interactive controls, you
can save the plot as a PNG file. But it's not possible to overlay
plots the way you can with \code{contourPlot()}.
}
\examples{
\dontrun{
interactive_plot(
    sin(fred*ginger) ~ fred + ginger,
    domain(fred=range(0,pi),
           ginger = range(0, pi)),
    type = "both")
}

}
