% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_motifs.R
\name{compare_to_baseline}
\alias{compare_to_baseline}
\title{Compare motif occurence in empirical network to occurence in a baseline model}
\usage{
compare_to_baseline(
  net,
  motifs,
  n = 10,
  lvl_attr = "sesType",
  assume_sparse = TRUE,
  model = "erdos_renyi",
  level = -1,
  ergm_model = NULL,
  directed = NULL
)
}
\arguments{
\item{net}{network object}

\item{motifs}{list of motif identifier strings}

\item{n}{number of random graphs used in baseline model}

\item{lvl_attr}{character vector specifying the attribute name where level
information is stored in \code{net}.}

\item{assume_sparse}{whether the random graphs shall be assumed to be sparse.
used to find ideal counting function}

\item{model}{baseline model to be used. Options are 'erdos_renyi', 'actors_choice',
'ergm', 'partial_ergm' and fixed_densities'.
See \code{vignette("random_baselines")} for more details.
  Defaults to 'erdos_renyi'.}

\item{level}{lvl_attr of the variable level for the Actor's Choice model}

\item{ergm_model}{ergm model as for example fitted by calling
\code{ergm::ergm()} on the empirically observed network.
Needs to be supplied when model is set to ergm.}

\item{directed}{whether the graph shall be treated as a directed graph. Per
default (\code{NULL}), this is determined automatically using the structure
of the provided network object}
}
\value{
data frame with one row for each motif identifier string and one row
  for every computed random graph
}
\description{
This function plots a comparison of the motif counts in a given network with the motif
counts in a baseline model.
}
\details{
Note that when using the Actor's Choice model this function does not choose
the variable level automatically. Use the \code{level} parameter to provide a
valid level.

When using ERGM the parameter \code{net} is not used. Networks to create the
baseline from are sampled in R using the \code{ergm_model} parameter.
}
\examples{
\dontrun{
compare_to_baseline(ml_net, list("1,2[I.C]", "1,2[II.C]"), directed = FALSE)
}
}
