% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_QxEC.R
\name{plot_QxEC}
\alias{plot_QxEC}
\title{plot QTLxEC effect}
\usage{
plot_QxEC(
  Qeff,
  EC,
  env_id = NULL,
  QTL,
  sign_thre = 0.05,
  EC_id = "EC",
  trait_id = "trait",
  main = "QTLxEC",
  col_vec = NULL,
  text_size = 14
)
}
\arguments{
\item{Qeff}{output from the function \code{\link{QTL_effect_main_QxEC}}.}

\item{EC}{\code{Numeric} matrix containing the EC values of a single covariate
with environments as row and EC as column.}

\item{env_id}{\code{Character} vector specifying the environment names.
By default, E1, ... En}

\item{QTL}{\code{Numeric value} indicating which QTL to plot}

\item{sign_thre}{\code{Numeric value} indicating the significance threshold for a
parent sensitivity slope to be ploted. Default = 0.05}

\item{EC_id}{\code{Character} string indicating the name of the environmental covariate.
Default = 'EC'.}

\item{trait_id}{\code{Character} string indicating the name of the trait.
Default = 'trait'.}

\item{main}{\code{Character} string title of the plot. Default = 'QTLxEC'}

\item{col_vec}{\code{Character} vector specifying colors for the parent sensitivity lines.
Default = NULL}

\item{text_size}{\code{Numerical} value specifying the size of the text in the plot.
Default = 14.}
}
\value{
QTLxEC sensitivity plot
}
\description{
Plot allowing the visualization of the QTL parental allelic effect variation
given an environmental covariate (EC). The function plot the sensitivity
curve of the parent allelic effects.
}
\examples{

\dontrun{

data(mppData_GE)

Qpos <- c("PZE.105068880", "PZE.106098900")

EC <- matrix(c(180, 310, 240, 280), 4, 1)
rownames(EC) <- c('CIAM', 'TUM', 'INRA', 'KWS')
colnames(EC) <- 'cum_rain'

Qeff <- QTL_effect_main_QxEC(mppData = mppData_GE,
                         trait = c('DMY_CIAM', 'DMY_TUM', 'DMY_INRA_P', 'DMY_KWS'),
                         env_id = c('CIAM', 'TUM', 'INRA', 'KWS'),
                         QTL = Qpos, EC = EC)

pl <- plot_QxEC(Qeff, EC = EC, env_id = c('CIAM', 'TUM', 'INRA', 'KWS'), 
                QTL = 2, EC_id = 'cum rain', trait_id = 'DMY')

}

}
\author{
Vincent Garin
}
