% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{removeNoise}
\alias{removeNoise}
\title{A function for removing bins below noise level.}
\usage{
removeNoise(mrbinResults, verbose = TRUE, errorsAsWarnings = FALSE)
}
\arguments{
\item{mrbinResults}{An mrbin object}

\item{verbose}{Should a summary be printed?}

\item{errorsAsWarnings}{If TRUE, errors will be turned into warnings. Should be used with care, as errors indicate undocumented changes to the data.}
}
\value{
An invisible mrbin object
}
\description{
This function checks for each bin (column) whether its level is below the
individual noise level times the signal-to-noise ratio. If less than the
defined threshold level are above noise*SNR, the whole bin is removed.
}
\examples{
resetEnv()#clean up previous data from the package environment 
results<-mrbin(silent=TRUE,setDefault=TRUE,parameters=list(dimension="1D",
                   binwidth1D=0.05,noiseRemoval="No",PQNScaling="No",
                   fixNegatives="No",logTrafo="No",PCA="No",verbose=TRUE,
                   NMRvendor="mrbin",
                   example=TRUE,#only used for the package examples
                   NMRfolders=c(system.file("extdata/1.mr1",package="mrbin"),
                                system.file("extdata/2.mr1",package="mrbin"),
                                system.file("extdata/3.mr1",package="mrbin"))))
results<-removeNoise(results)
}
