% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbsizeRgrid.R
\name{mrbsizeRgrid}
\alias{mrbsizeRgrid}
\title{Multiresolution analysis of random signals.}
\usage{
mrbsizeRgrid(
  posteriorFile,
  mm,
  nn,
  lambdaSmoother,
  prob = 0.95,
  smoothOut = FALSE
)
}
\arguments{
\item{posteriorFile}{Matrix with posterior samples as column vectors.}

\item{mm}{Number of rows of the original object.}

\item{nn}{Number of columns of the original object.}

\item{lambdaSmoother}{Vector consisting of the smoothing levels to be used.}

\item{prob}{Credibility level for the posterior credibility analysis.}

\item{smoothOut}{Should the differences of smooths at neighboring scales be 
returned as output (FALSE by default)?}
}
\value{
A list containing the following sublists:

\code{smMean} Posterior mean of all differences of smooths created.

\code{hpout} Pointwise (PW) and highest pointwise (HPW) probabilities 
    of all differences of smooths created.

\code{ciout} Simultaneous credible intervals (CI) of all differences of
    smooths created.

\code{smoothSamples} Samples of differences of smooths at neighboring scales, 
    as column vectors.
}
\description{
\code{mrbsizeRgrid} is the interface of the scale space multiresolution method
for data on a regular grid. Here, the differences of smooths as well as the posterior 
credibility analysis are computed. The output can be analyzed with the plotting
functions \code{\link{plot.smMeanGrid}}, \code{\link{plot.CImapGrid}} and 
\code{\link{plot.HPWmapGrid}}.
}
\details{
\code{mrbsizeRgrid} conducts two steps of the scale space multiresolution analysis:
\enumerate{
    \item Extraction of scale-dependent features from the reconstructed signal.
        This is done by smoothing at different smoothing levels and taking the
        difference of smooths at neighboring scales.
    \item Posterior credibility analysis of the differences of smooths created.
        Three different methods are applied: Pointwise probabilities (see \code{\link{HPWmap}}),
        highest pointwise probabilities (see \code{\link{HPWmap}}) and simultaneous 
        credible intervals (see \code{\link{CImap}}).
}
The signal can be reconstructed using the build-in multivariate t-distribution
sampling \code{\link{rmvtDCT}}. It is also possible to provide samples 
generated with other methods, see the parameter \code{posteriorFile} and the
examples.

For further information and examples, see the vignette.
}
\examples{
# Artificial sample data
set.seed(987)
sampleData <- matrix(stats::rnorm(100), nrow = 10)
sampleData[4:6, 6:8] <- sampleData[4:6, 6:8] + 5

# Generate samples from multivariate t-distribution
tSamp <- rmvtDCT(object = sampleData, lambda = 0.2, sigma = 6, nu0 = 15,
                  ns = 1000)  
 
# mrbsizeRgrid analysis
mrbOut <- mrbsizeRgrid(posteriorFile = tSamp$sample, mm = 10, nn = 10, 
                       lambdaSmoother = c(1, 1000), prob = 0.95)

}
