% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.df.covar.line.R
\name{add.df.covar.line}
\alias{add.df.covar.line}
\alias{add_df_covar_line}
\title{Add covariate levels detection function plots}
\usage{
add.df.covar.line(ddf, data, ndist = 250, pdf = FALSE, breaks = "Sturges", ...)

add_df_covar_line(ddf, data, ndist = 250, pdf = FALSE, breaks = "Sturges", ...)
}
\arguments{
\item{ddf}{a fitted detection function object.}

\item{data}{a \code{data.frame} with the covariate combination you want to
plot.}

\item{ndist}{number of distances at which to evaluate the detection function.}

\item{pdf}{should the line be drawn on the probability density scale;
ignored for line transects.}

\item{breaks}{required to ensure that PDF lines are the right size, should
match what is supplied to original \code{plot} command. Defaults to
"Sturges" breaks, as in \code{\link{hist}}. Only used if \code{pdf=TRUE}.}

\item{\dots}{extra arguments to give to \code{\link{line}} (\code{lty},
\code{lwd}, \code{col}).}
}
\value{
invisibly, the values of detectability over the truncation range.
}
\description{
Add a line or lines to a plot of the detection function which correspond to
a a given covariate combination. These can be particularly useful when there
is a small number of factor levels or if quantiles of a continuous covariate
are specified.
}
\details{
All covariates must be specified in \code{data}. Plots can become quite busy
when this approach is used. It may be useful to fix some covariates at their
median level and plot set values of a covariate of interest. For example
setting weather (e.g., Beaufort) to its median and plotting levels of
observer, then creating a second plot for a fixed observer with levels of
weather.

Arguments to \code{\link{lines}} are supplied in \dots and aesthetics like
line type (\code{lty}), line width (\code{lwd}) and colour (\code{col}) are
recycled. By default \code{lty} is used to distinguish between the lines. It
may be useful to add a \code{\link{legend}} to the plot (lines are plotted
in the order of \code{data}).
}
\examples{
\dontrun{
# fit an example model
data(book.tee.data)
egdata <- book.tee.data$book.tee.dataframe
result <- ddf(dsmodel = ~mcds(key = "hn", formula = ~sex),
              data = egdata[egdata$observer==1, ], method = "ds",
              meta.data = list(width = 4))

# make a base plot, showpoints=FALSE makes the plot less busy
plot(result, showpoints=FALSE)

# add lines for sex one at a time
add.df.covar.line(result, data.frame(sex=0), lty=2)
add.df.covar.line(result, data.frame(sex=1), lty=3)

# add a legend
legend(3, 1, c("Average", "sex==0", "sex==1"), lty=1:3)

# alternatively we can add both at once
# fixing line type and varying colour
plot(result, showpoints=FALSE)
add.df.covar.line(result, data.frame(sex=c(0,1)), lty=1,
                  col=c("red", "green"))
# add a legend
legend(3, 1, c("Average", "sex==0", "sex==1"), lty=1,
       col=c("black", "red", "green"))
}
}
\author{
David L Miller
}
