% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_gaz_search.R
\name{gaz_rest_records_by_names}
\alias{gaz_rest_records_by_names}
\title{Get Gazetteer Records for all given names}
\usage{
gaz_rest_records_by_names(
  names,
  with_geometry = FALSE,
  like = TRUE,
  fuzzy = TRUE
)
}
\arguments{
\item{names}{(character) Vector with the terms to search in the Marine Regions Gazetteer}

\item{with_geometry}{(logical) Add geometry to the result data frame? Default = FALSE}

\item{like}{(logical) Add a '\%'-sign before and after the name? (SQL LIKE function). Default = TRUE}

\item{fuzzy}{(logical) Use Levenshtein query to find nearest matches? Default = TRUE}
}
\value{
A data frame with Gazetteer entries
}
\description{
Get Gazetteer Records for all given names
}
\examples{
\donttest{
gaz_rest_records_by_names(
  c("Belgian Exclusive Economic Zone", "Dutch Exclusive Economic Zone")
)
}
}
\seealso{
\link{gaz_rest}, \link{gaz_rest_records_by_name}
}
