% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_mrp_get.R
\name{mrp_get}
\alias{mrp_get}
\title{Get a data product}
\usage{
mrp_get(
  layer,
  path = getOption("mregions2.download_path", tempdir()),
  cql_filter = NULL,
  filter = NULL,
  count = NULL
)
}
\arguments{
\item{layer}{(character) Identifier of the data product. See \link{mrp_list}}

\item{path}{(character) Path to save the requests. Default is \code{\link[base:tempfile]{base::tempdir()}}. See details.}

\item{cql_filter}{(character) Contextual Query Language (CQL) filter. See details.}

\item{filter}{(character) Standard OGC filter specification. See details.}

\item{count}{(numeric) Maximum number of features to be retrieved.}
}
\value{
An sf object with the Marine Regions data product
}
\description{
Get a data product
}
\details{
This function uses \href{https://en.wikipedia.org/wiki/Web_Map_Service}{WFS services} to download the
Marine Regions layers as ESRI Shapefiles.
\subsection{Caching}{

By default, the layers are downloaded to a temporal directory (\code{\link[base:tempfile]{base::tempdir()}}). You can provide
a path in the \code{path} argument. But you can also set a path with \verb{# options("mregions2.download_path" = "my/path/")}.

Because it is possible to add filters, each request is identified with a crc32 hash, provided with
\code{\link[digest:digest]{digest::digest()}} and attached to the file downloaded.

Once a layer is downloaded, it will be read from the cache during the next two weeks. To avoid this, simply
delete the layers in the cache path.
}

\subsection{Filters}{

Both the \href{https://portal.ogc.org/files/96288}{Contextual Query Language (CQL) filter} and the \href{https://www.ogc.org/publications/standard/filter/}{standard OGC filter specification} allow to
query the server before performing a request. This will boost performance as you will only retrieve the area of your interest. It is possible to query on attributes, but also perform
geospatial queries. For instance, you can query a bounding box of interest.

CQL filters are possible only in geoserver. Marine Regions uses a geoserver instance to serve its data products.
A tutorial on CQL filters is available in the \href{https://docs.geoserver.org/stable/en/user/tutorials/cql/cql_tutorial.html}{geoserver web site}.
}
}
\examples{
\donttest{
# Set cache path. Default is a temporal directory
options(mregions2.download_path = tempdir())

getOption("mregions2.download_path")
#> [1] "/tmp/RtmpARLgoE"

# See the list of all data products
mrp_list

# We want the Exclusive Economic Zones of Portugal. Let's first visualize the product:
mrp_view("eez")

# See all the columns on this data product
mrp_colnames("eez")

# We should query on sovereign
# See all the possible values of sovereign1, sovereign2 and sovereign3
sov1 = mrp_col_unique("eez", "sovereign1")
sov2 = mrp_col_unique("eez", "sovereign2")
sov3 = mrp_col_unique("eez", "sovereign3")

# Is Portugal a value in the sovereign1, 2 and 3?
"Portugal" \%in\% sov1
#> [1] TRUE

"Portugal" \%in\% sov2
#> [1] FALSE

"Portugal" \%in\% sov3
#> [1] FALSE

# Portugal is only in sovereign1. Let's write a CQL filter to get only
# the EEZs of Portugal, or those where Portugal is a party of a dispute or a joint regime
portugal_eez <- mrp_get("eez", cql_filter = "sovereign1 = 'Portugal'")

# If you perform this request again, it will be read from the cache instead
portugal_eez <- mrp_get("eez", cql_filter = "sovereign1 = 'Portugal'")
#> Cache is fresh. Reading: /tmp/RtmpARLgoE/eez-1951c8b7/eez.shp
#> (Last Modified: 2023-04-24 17:45:16)

# You can also limit the number of features to be requested
mrp_get("eez", count = 5)
}
}
\seealso{
\link{mrp_list} to describe the list of products, \code{\link[=mrp_view]{mrp_view()}} to visualize the data product in advance, \code{\link[=mrp_colnames]{mrp_colnames()}} and \code{\link[=mrp_col_unique]{mrp_col_unique()}} to get the name, data type and unique values of a the columns of a data product, useful to query
with the arguments \code{cql_filter} or \code{filter}
}
