% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msltrend.R
\name{msl.pdf}
\alias{msl.pdf}
\title{Pdf plotting options.}
\usage{
msl.pdf(x, file_name = " ", type = 1, ci = 1)
}
\arguments{
\item{x}{object of class \dQuote{msl.trend} (see \code{\link{msl.trend}} and
\code{\link{s}}) or \dQuote{msl.forecast} (see \code{\link{msl.forecast}} and
\code{\link{t}}).}

\item{file_name}{is a character string indicating the name of the pdf output
file. If this field is left blank the output file will be automatically saved
in the working directory under the default name "File1.pdf".}

\item{type}{numeric, enables a user defined input to select the type of chart
to be plotted. The default setting (type = 1) provides 3 charts in the same
plot area with the time series in the top panel, instantaneous velocity in
the middle panel and instantaneous acceleration in the bottom panel. The
alternatives (2, 3 and 4) are single panel plots of time series, instantaneous
velocity and instantaneous acceleration, respectively.}

\item{ci}{numeric, enables a user defined input to select the type of
confidence interval to be displayed on the plots. The default setting
(ci = 1) corresponds to a 95\% confidence interval whilst ci=2 provides a
99\% confidence interval.}
}
\description{
Pdf plotting options.
}
\details{
This routine provides a range of pdf plotting options for both
\dQuote{msl.trend} (see \code{\link{msl.trend}}) and \dQuote{msl.forecast}
(see \code{\link{msl.forecast}}) objects. Three panel plots (type 1 or
default) are formatted with width = 16.54 inches and height = 20 inches.
Single panel plots (types 2, 3, 4) are formatted with width = 16.54 inches
and height = 15 inches. All plots are designed to be proportionally correct
when imported into documents and re-sized to the width of a standard A4 page.
The same range of alternative screen plotting options are available via
\code{\link{msl.plot}}.
}
\examples{
# -------------------------------------------------------------------------
# Isolate trend from Baltimore record, filling gaps with spline interpolation,
# 500 iterations and adding 1000 mm of slr to 2100. Use raw 'Balt.csv' data file.
# Note: ordinarily user would call 'File.csv' direct from working directory
# using the following sample code:
# s <- msl.trend('Balt.csv', fillgaps = 3, iter = 500, 'BALTIMORE, USA')
# t <- msl.forecast(s, slr = 1000)
# -------------------------------------------------------------------------

data(s) # msl.trend object from above-mentioned example
data(t) # msl.forecast object from above-mentioned example

# default output, 3 panels, 95\% confidence intervals.
msl.pdf(s)
# Check 'File1.pdf' in working directory

# pdf plot time series, 95\% confidence intervals.
msl.pdf(s, file_name = 'Series.pdf', type = 2)
# Check 'Series.pdf' file in working directory

# pdf plot instantaneous velocity, 95\% confidence intervals.
msl.pdf(s, file_name = 'Velocity.pdf', type = 3)
# Check 'Velocity.pdf' file in working directory

# pdf plot instantaneous acceleration, 99\% confidence intervals.
msl.pdf(s, file_name = 'Acceleration.pdf', type = 4, ci = 2)
# Check 'Acceleration.pdf' file in working directory

# default output, 3 panels, 95\% confidence intervals.
msl.pdf(t, file_name = 'Forecast.pdf')
# Check 'Forecast.pdf' file in working directory

}
\seealso{
\code{\link{msl.trend}}, \code{\link{msl.forecast}},
\code{\link{msl.plot}}, \code{\link{Balt}}, \code{\link{s}}, \code{\link{t}}.
}

