% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperfunctions_extract.R
\name{extract_components_uni}
\alias{extract_components_uni}
\title{Extract Model Components to be Compared from Univariate Model}
\usage{
extract_components_uni(model)
}
\arguments{
\item{model}{Univariate multiFAMM model object from which to extract the
information.}
}
\value{
A list with the following elements
  \itemize{
    \item \code{error_var}: A list containing the following elements
      \itemize{
      \item \code{model_weights}: Model weights used in the final multiFAMM.
      \item \code{modelsig2}: Estimate of sigma squared in the final model.
      \item \code{uni_vars}: Univariate estimates of sigma squared.}
    \item \code{eigenvals}: List containing the estimated eigenvalues.
    \item \code{fitted_curves}: multiFunData object containing the fitted
      curves.
    \item \code{eigenfcts}: multiFunData object containing the estimated
      eigenfunctions.
    \item \code{cov_preds}: multiFunData object containing the estimated
      covariate effects.
    \item \code{ran_preds}: List containing multiFunData objects of the
      predicted random effects.
    \item \code{scores}: List containing matrices of the estimated scores.}
}
\description{
This is an internal function that helps to compare different models. The
models resulting from a multiFAMM() call are typically very big. This
function extracts the main information from a univariate model so that a
smaller R object can be saved.
}
\details{
So far the grid is fixed to be on [0,1].
}
