% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff_num_func.R
\name{getMF_eff}
\alias{getMF_eff}
\title{getMF_eff}
\usage{
getMF_eff(
  data,
  vars,
  q = 1,
  standardized = FALSE,
  standardize_function = standardizeUnitScale,
  D = NULL,
  tau = NULL
)
}
\arguments{
\item{data}{A data frame with functions in columns and rows as replicates as well as other information.}

\item{vars}{Name of function variables}

\item{q}{Order of the diversity measure. Defaults to the
Shannon case where q = 1. For Simpson, q=2.}

\item{standardized}{Use standardized number of functions (scaled by total
number of functions, so between 0-1), or just raw effective number of
functions for calculation. Defaults to \code{FALSE}.}

\item{standardize_function}{A function to standardize each individual
function to the same scale, such as \code{standardizeUnitScale} or
\code{standardizeZScore}}

\item{D}{A distance matrix describing dissimilarity between functions. Defaults
to NULL, and the index is calculated assuming all functions are different. If
it is not null, it must be a symmetric matrix with dimensions matching the
number of functions listed in \code{vars}.}

\item{tau}{A cutoff for degree of dissimilarity under which functions are considered
to be different. If tau is the minimum non-zero value of D, all functions are different.
if tau is the maximum value of D are greater, all functions are considered the same.}
}
\value{
Returns a vector of effective or standardized effective multifunctionality.
}
\description{
A multifunctionality index rooted in Hill numbers.
\code{getMF_eff} get multifunctionality index defined by function and effective number of functions
}
\details{
Takes a data frame, variable names, a standardizing function, whether we want
an index standardized by number of functions or not, an order of Hill number for our
effective number of functions as well as a dissimilarity matrix (if desired) and value
for a dissimilarity cutoff (defaults to the average dissimilarity). It then calculates
both the average standardized function in each plot and the effective number of
functions and returns their product as a measure of effective multifunctionality.
}
\references{
Chao, A., Chiu, C.-H., Villéger, S., Sun, I.-F., Thorn, S., Lin, Y.-C.,
Chiang, J.-M. and Sherwin, W. B. 2019. An attribute-diversity approach to
functional diversity, functional beta diversity, and related (dis)similarity
measures. Ecological Monographs. 89: e01343.

Jost, L. 2006. Entropy and diversity. Oikos 113(2): 363-375.

Hill, M. 1973. Diversity and evenness: A unifying notation and its
consequences. Ecology 54: 427-432.
}
\author{
Jarrett Byrnes.
}
