% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{MultiLand-class}
\alias{MultiLand-class}
\title{Class "MultiLand"}
\description{
Objects of class 'MultiLand' are created with the function \code{\link[=mland]{mland()}}, and holds
relevant objects and information to be passed to other functions of the package. The slot
\verb{@buffers} holds an object of class 'SpatVector' with the buffers for each point
contained in the slot \verb{@points} and each radius defined in slot \verb{@radii}. The slot
\verb{@buffers@data} holds a data.frame with the identification of each buffer (individualized by a
point id and a radius value).
}
\details{
If the slot \verb{@on_the_fly} equals \code{FALSE}, the slot \verb{@landscapes} holds the intersections (objects of class 'SpatRaster') between
buffers and the raster layers inputted by the user when running \code{\link[=mland]{mland()}}. Intersections
between buffers and raster layers with discrete values (inputted in argument \code{raster} in \code{\link[=mland]{mland()}}) are
contained inside a list named 'lsm_rasters', whereas intersections between extra raster layers
(inputted in argument \code{ext_rast_layer} in \code{\link[=mland]{mland()}}) and buffers
are contained inside a list named 'ext_rasters'. Each list ('lsm_rasters' and 'ext_rasters') contains a
list with as many elements as previously inputted raster layers. Additionally, each element of
this latter list holds an additional internal list, with as many elements as intersections (i.e. rasters generated by the intersections between buffers defined
by each point and radius, and the raster layer). The name of each element of each internal list
reveals the information related to a given intersection, with the following coding: "RasterLayerL-P-R" or
"ExtRasterLayerL-P-R", where L is the
given raster layer, P is the id of the point and R is the radius. For example, a plausible
intersection may be named as "RasterLayer1-5-1500", indicating that this element holds a raster
layer which is the result of the intersection between RasterLayer1 and the buffer around point 5 and
radius 1500 m.

If slot \verb{@on_the_fly} equals \code{FALSE}, the slot \verb{@landscapes} holds a list containing two named lists
as 'lsm_rasters' and 'ext_rasters'. Each one contains a list with as many raster layers were initially
inputted by the user when running \code{\link[=mland]{mland()}} in arguments \code{rast_layer} and \code{ext_rast_layer}.
This means that no intersections were
made when creating the 'MultiLand' object. Intersections will be created "on the fly" when other functions of
the package requires them.
}
\section{Slots}{

\describe{
\item{\code{call}}{The call when function \code{\link[=mland]{mland()}} was called.}

\item{\code{idkey}}{A unique identification id for the 'MultiLand' object.}

\item{\code{crs_proj}}{A string depicting the CRS of points layer.}

\item{\code{points}}{An object of class 'SpatVector'. Holds the points inputted by the user.}

\item{\code{buffers}}{An object of class 'SpatVector'. Holds the buffers layers.}

\item{\code{site_ref}}{String holding the name of the attribute that the user defined as
the one that identifies individual points and is contained inside the layer of points.}

\item{\code{radii}}{Vector of numbers containing the radii that defined the creation of buffers.}

\item{\code{n_layers}}{Number of raster layers (defined in argument \code{raster} in \code{\link[=mland]{mland()}}) from which i
ntersections between were created (or will be if slot \verb{@on_the_fly = TRUE}).}

\item{\code{n_classes}}{A numeric vector depicting the number of classes (raster values) per raster
layer (defined in argument \code{raster} in \code{\link[=mland]{mland()}}).}

\item{\code{classes}}{A data.frame depicting the classes (and classes names) for each rasterlayer
(defined in argument \code{raster} in \code{\link[=mland]{mland()}}).}

\item{\code{on_the_fly}}{A logical value indicating whether intersections between buffers and raster layers
were created (FALSE) or not (TRUE).}

\item{\code{landscapes}}{If \code{on_the_fly = FALSE}, this slot holds the intersections between buffers and
raster layers. Otherwise, if \code{on_the_fly = TRUE}, it holds the raw raster layers.}

\item{\code{l_ref}}{A data.frame relating each point and radius with a "row_id", equal to the position of
its buffer in the slot \verb{@buffers} and to the position of the intersection for each point/radius in
the slot \verb{@landscapes} (if \code{on_the_fly = TRUE}).}

\item{\code{rast_names}}{A list containing two data.frame with the names assigned by the user for the main raster layers
and extra raster layers defined in argument \code{rast_layer} and \code{ext_rast_layer} in \code{\link[=mland]{mland()}}.}
}}

\examples{
# Shows information of object 'MultiLand'
ernesdesign <- system.file("extdata", "ernesdesign.zip", package = "multilandr")
ernesdesign <- mland_load(ernesdesign)
ernesdesign
}
