% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{null_contrast}
\alias{null_contrast}
\title{Compare Effects from Experimental vs. Null Mediation Data}
\usage{
null_contrast(model, exper, nullification = "T->Y", f = direct_effect)
}
\arguments{
\item{model}{An object of class multimedia with specified mediation and
outcome models that we want to re-estimate across B bootstrap samples.}

\item{exper}{An object of class multimedia_data containing the mediation and
outcome data from which the direct effects are to be estimated.}

\item{nullification}{A string specifying the types of edges whose effects we
want to remove in the null samples. Valid options are "T->Y" (the default),
"T->M", "M->Y", which remove direct effects, treatment to mediator effects,
and mediator to treatment effects, respectively.}

\item{f}{The estimator that we want to compare between real and null data.
This is assumed to be a function taking counterfactual samples, for example
\code{direct_effects} or \code{indirect_effects}.}
}
\value{
A data.frame containing estimates on the real and synthetic data for
every coordinate in the estimator f. The column \code{source} specifies whether
the estimate was calculated using real or synthetic null data.
}
\description{
One way to calibrate our conclusions from complex workflows is to see how
they would look on data where we know that there is no effect. This function
compares estimators f between real and synthetic null data, where the null
removes a set of edges according to the nullfication argument.
}
\examples{
# example with null data - notice synthetic data has larger effect.
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper) |>
    estimate(exper) |>
    null_contrast(exper)

# example with another dataset - synthetic effect is smaller.
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
multimedia(exper) |>
    estimate(exper) |>
    null_contrast(exper)
}
\seealso{
null_contrast fdr_summary
}
