% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvQuad.R
\name{rescale (rescale.NIGrid)}
\alias{rescale}
\alias{rescale (rescale.NIGrid)}
\alias{rescale.NIGrid}
\title{moves, rescales and/or rotates a multidimensional grid.}
\usage{
rescale(object, ...)

\method{rescale}{NIGrid}(object, domain = NULL, m = NULL, C = NULL,
  dec.type = 0, ...)
}
\arguments{
\item{object}{an initial grid of type \code{NIGrid}}

\item{...}{further arguments passed to or from other methods}

\item{domain}{a (d x 2)-matrix with the boundaries for each dimension}

\item{m}{vector of means}

\item{C}{covariance matrix}

\item{dec.type}{type of covariance decomposition (\cite{Peter Jaeckel (2005)})}
}
\value{
This function modifies the "support-attribute" of the grid. The
recalculation of the nodes and weights is done when the \code{\link{getNodes}} or \code{\link{getWeights}}
are used.
}
\description{
\code{rescale.NIGrid} manipulates a grid for more efficient numerical integration with
respect to a given domain (bounded integral) or vector
of means and covariance matrix (unbounded integral).
}
\examples{
C = matrix(c(2,0.9,0.9,2),2)
m = c(-.5, .3)
par(mfrow=c(3,1))

myGrid <- createNIGrid(dim=2, type="GHe", level=5)

rescale(myGrid, m=m, C=C, dec.type=0)
plot(myGrid, col="red")

rescale(myGrid, m=m, C=C, dec.type=1)
plot(myGrid, col="green")

rescale(myGrid, m=m, C=C, dec.type=2)
plot(myGrid, col="blue")
}
\references{
Peter Jaeckel (2005): A note on multivariate Gauss-Hermite quadrature
}
\seealso{
\code{\link{quadrature}}, \code{\link{createNIGrid}}
}

