% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidier_methods.R
\name{tidy.mvgam}
\alias{tidy.mvgam}
\title{Tidy an \code{mvgam} object's parameter posteriors}
\usage{
\method{tidy}{mvgam}(x, probs = c(0.025, 0.5, 0.975), ...)
}
\arguments{
\item{x}{An object of class \code{mvgam}.}

\item{probs}{The desired probability levels of the parameters' posteriors.
Defaults to \code{c(0.025, 0.5, 0.975)}, i.e. 2.5\%, 50\%, and 97.5\%.}

\item{...}{Unused, included for generic consistency only.}
}
\value{
A \code{tibble} containing:
\itemize{
\item "parameter": The parameter in question.
\item "type": The component of the model that the parameter belongs to (see
details).
\item "mean": The posterior mean.
\item "sd": The posterior standard deviation.
\item percentile(s): Any percentiles of interest from these posteriors.
}
}
\description{
Get parameters' posterior statistics, implementing the generic \code{tidy} from
the package \pkg{broom}.
}
\details{
The parameters are categorized by the column "type". For instance, the
intercept of the observation model (i.e. the "formula" arg to \code{mvgam()}) has
the "type" "observation_beta". The possible "type"s are:
\itemize{
\item observation_family_extra_param: any extra parameters for your observation
model, e.g. sigma for a gaussian observation model. These parameters are
not directly derived from the latent trend components (contrast to mu).
\item observation_beta: betas from your observation model, excluding any
smooths. If your formula was \code{y ~ x1 + s(x2, bs='cr')}, then your
intercept and \code{x1}'s beta would be categorized as this.
\item random_effect_group_level: Group-level random effects parameters, i.e.
the mean and sd of the distribution from which the specific random
intercepts/slopes are considered to be drawn from.
\item random_effect_beta: betas for the individual random intercepts/slopes.
\item trend_model_param: parameters from your \code{trend_model}.
\item trend_beta: analog of "observation_beta", but for any \code{trend_formula}.
\item trend_random_effect_group_level: analog of
"random_effect_group_level", but for any \code{trend_formula}.
\item trend_random_effect_beta: analog of "random_effect_beta", but for any
\code{trend_formula}.
}

Additionally, GP terms can be incorporated in several ways, leading to
different "type"s (or absence!):
\itemize{
\item \code{s(bs = "gp")}: No parameters returned.
\item \code{gp()} in \code{formula}: "type" of "observation_param".
\item \code{gp()} in \code{trend_formula}: "type" of "trend_formula_param".
\item \code{GP()} in \code{trend_model}: "type" of "trend_model_param".
}
}
\examples{
\dontrun{
set.seed(0)
simdat <- sim_mvgam(
  T = 100,
  n_series = 3,
  trend_model = AR(),
  prop_trend = 0.75,
  family = gaussian()
)

simdat$data_train$x <- rnorm(nrow(simdat$data_train))
simdat$data_train$year_fac <- factor(simdat$data_train$year)

mod <- mvgam(
  y ~ -1 + s(time, by = series, bs = 'cr', k = 20) + x,
  trend_formula = ~ s(year_fac, bs = 're') - 1,
  trend_model = AR(cor = TRUE),
  family = gaussian(),
  data = simdat$data_train,
  silent = 2
)

tidy(mod, probs = c(0.2, 0.5, 0.8))
}

}
\seealso{
Other tidiers: 
\code{\link{augment.mvgam}()}
}
\concept{tidiers}
