% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooks.distance.mlm.R
\name{cooks.distance.mlm}
\alias{cooks.distance.mlm}
\title{Cook's distance for a MLM}
\usage{
\method{cooks.distance}{mlm}(model, infl = mlm.influence(model, do.coef = FALSE), ...)
}
\arguments{
\item{model}{A \code{mlm} object, fit by \code{lm()}}

\item{infl}{A \code{inflmlm} object. The default simply runs \code{mlm.influence()} on the model, suppressing coefficients.}

\item{...}{Ignored}
}
\value{
A vector of Cook's distances
}
\description{
The functions \code{cooks.distance.mlm} and \code{hatvalues.mlm} are
designed as extractor functions for regression deletion diagnostics for
multivariate linear models following Barrett & Ling (1992). These are close
analogs of methods for univariate and generalized linear models handled by
the \code{\link[stats]{influence.measures}} in the \code{stats} package.
}
\details{
In addition, the functions provide diagnostics for deletion of subsets of
observations of size \code{m>1}.
}
\examples{

data(Rohwer, package="heplots")
Rohwer2 <- subset(Rohwer, subset=group==2)
rownames(Rohwer2)<- 1:nrow(Rohwer2)
Rohwer.mod <- lm(cbind(SAT, PPVT, Raven) ~ n+s+ns+na+ss, data=Rohwer2)

hatvalues(Rohwer.mod)
cooks.distance(Rohwer.mod)

}
\references{
Barrett, B. E. and Ling, R. F. (1992). General Classes of
Influence Measures for Multivariate Regression. \emph{Journal of the
American Statistical Association}, \bold{87}(417), 184-191.
}
\keyword{models}
\keyword{regression}
