% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.generation.new.R
\name{data.generation}
\alias{data.generation}
\title{Data generation function}
\usage{
data.generation(
  num_ind = 2000,
  mean_vec = rnorm(5),
  cov_mat = diag(5),
  miss_var = c(2, 3),
  miss_mech = "MCAR",
  miss_prob = c(0.2, 0.4),
  censor_var = 4,
  censor_type = "interval",
  censor_param = 0.1
)
}
\arguments{
\item{num_ind}{number of subjects.}

\item{mean_vec}{mean vectors.}

\item{cov_mat}{covariance matrix.}

\item{miss_var}{variables that have missing values.}

\item{miss_mech}{missing mechanism. "MCAR" or "MAR". Default "MCAR".}

\item{miss_prob}{missing data probability when missing data is MCAR.}

\item{censor_var}{variables that have censored values.}

\item{censor_type}{type of censoring. "interval", "right" or "left. Default "interval".}

\item{censor_param}{rate parameter of the exponential distribution that the censoring times come from.}
}
\value{
A list containing the fully observed data, the observed data,
the bounds information of the observed data and the data type indicator matrix.
}
\description{
Simulates multivariate normal data with missing and censored values. In this function, missing values will be
generated first in the multivariate data, then censored values will be generated for the non-missing data.
}
\examples{
### generate a multivariate normal dataset of 2000 sample size
### using the default arguments
data.generation()

}
