% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extdata.R
\name{save_nl_in_parts}
\alias{save_nl_in_parts}
\title{Save a neuronlist object into separate data and metadata parts}
\usage{
save_nl_in_parts(
  x,
  datapath = NULL,
  dfpath = NULL,
  extdata = TRUE,
  format = c("rds", "rda"),
  ...
)
}
\arguments{
\item{x}{A neuronlist object to save in separate parts}

\item{datapath}{Optional path to new data file (constructed from name of
\code{x} argument when missing)}

\item{dfpath}{Optional path to new metadata file (constructed from
\code{datapath} when missing)}

\item{extdata}{Logical indicating whether the files should be saved into
extdata folder (default \code{TRUE}, when \code{FALSE} the paths are
untouched)}

\item{format}{Either \code{'rds'} (default) or \code{'rda'}.}

\item{...}{Additional arguments passed to \code{\link{saveRDS}} or
\code{\link{save}} (based on the value of \code{format}).}
}
\value{
character vector with path to the saved files (returned invisibly)
}
\description{
Save a neuronlist object into separate data and metadata parts
}
\details{
Saves a neuronlist into separate data and metadata parts. This can
  significantly mitigate git repository bloat since only the metadata object
  will change when any metadata is updated. By default the objects will be
  saved into the package \code{inst/extdata} folder with sensible names based
  on the incoming object. E.g. if \code{x=mypns} the files will be \itemize{

  \item mypns.rds

  \item mypns.df.rds

  }
}
\examples{
\dontrun{
save_nl_in_parts(pns)
# which would make:
# - inst/extdata/pns.rds
# - inst/extdata/pns.df.rds

save_nl_in_parts(pns, format='rda')
# which would make:
# - inst/extdata/pns.rda
# - inst/extdata/pns.df.rda

save_nl_in_parts(pns, 'mypns.rda')
# which would make (NB format argument wins):
# - inst/extdata/mypns.rds
# - inst/extdata/mypns.df.rds
}
}
\seealso{
Other extdata: 
\code{\link{find_extdata}()},
\code{\link{read_nl_from_parts}()}
}
\concept{extdata}
