% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prioritize.R
\name{prioritize}
\alias{prioritize}
\title{Re-attach packages to prevent masking}
\usage{
prioritize(...)
}
\arguments{
\item{...}{Packages, given as unquoted names or character strings. Earlier
arguments will be attached later (and therefore get a higher priority).}
}
\description{
\code{prioritize} detaches packages from the search path, then
  re-attaches them, placing them at the beginning of the search path to
  prevent masking. This allows for the loading of packages with conflicting
  function names in any order.
}
\details{
If you find yourself calling this function a lot, you're probably
  doing something wrong.
}
\examples{
\dontrun{

# loading plyr after dplyr causes badness
needs(dplyr, plyr)

# prioritize the functions in dplyr
prioritize(dplyr)

}

}

