% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neo4j_rmdir.R
\name{neo4j_rmdir}
\alias{neo4j_rmdir}
\title{Remove subdirectory and all its contents from the Neo4J import directory}
\usage{
neo4j_rmdir(
  local = FALSE,
  con = list(address = NULL, uid = NULL, pwd = NULL),
  dir = NULL,
  import_dir = "import"
)
}
\arguments{
\item{local}{Logical indicating whether import is to a locally hosted or remotely hosted server.}

\item{con}{If remotely hosted server, list containing three objects: address, uid, pwd as character strings providing connection to the Neo4J server.
uid and pwd must be for an account on the server with appropriate permissions.}

\item{dir}{Character string of the Neo4J import subdirectory name to be deleted.}

\item{import_dir}{Character string of path to the Neo4J import directory.}
}
\value{
A success message if successful.  A error message otherwise.
}
\description{
Remove subdirectory and all its contents from the Neo4J import directory
}
\examples{
# remove a subdirectory and all its contents from the local import directory
fs::dir_create("import/data")
fs::file_create("import/data/data.csv")
neo4j_rmdir(local = TRUE, dir = "data", import_dir = "import")
fs::dir_delete("import")
}
