% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.predict.R
\name{as.data.frame.predictNestedLogit}
\alias{as.data.frame.predictNestedLogit}
\title{Convert a Predicted Objects to a data.frame}
\usage{
\method{as.data.frame}{predictNestedLogit}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{a \code{"predictNestedLogit"} object}

\item{row.names}{row.names for result (for conformity with generic; not currently used)}

\item{optional}{logical. If TRUE, setting row names and converting column names
(to syntactic names: see \code{\link[base]{make.names}} is optional}

\item{...}{other arguments (unused)}
}
\value{
\itemize{
\item For \code{predict(\dots, model="nested")} (the default), returns
a data frame containing the values of predictors along with the columns
\code{response}, \code{p}, \code{se.p}, \code{logit}, \code{se.logit}.
\item For \code{predict(\dots, model="dichotomies")}, returns
a data frame containing the values of predictors along with the columns
\code{response}, \code{logit}, and \code{se.logit}.
}
}
\description{
These functions provide simple ways to convert the results of \code{\link{predict.nestedLogit}}
to a data frame in a consistent format for plotting and other actions.
}
\examples{
data("Womenlf", package = "carData")
comparisons <- logits(work=dichotomy("not.work", c("parttime", "fulltime")),
                     full=dichotomy("parttime", "fulltime"))

wlf.nested <- nestedLogit(partic ~ hincome + children,
                          dichotomies = comparisons,
                          data=Womenlf)
# get predicted values for a grid of `hincome` and `children`
new <- expand.grid(hincome=seq(0, 45, length=10),
                   children=c("absent", "present"))

pred.nested <- predict(wlf.nested, new)
plotdata <- as.data.frame(pred.nested)
str(plotdata)

# Predicted logit values for the dichotomies
pred.dichot <- predict(wlf.nested, new, model = "dichotomies")
plotlogit <- as.data.frame(pred.dichot)
str(plotlogit)
}
