% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex_filters.R
\name{pls_filter}
\alias{pls_filter}
\title{Partial Least Squares filter}
\usage{
pls_filter(
  y,
  x,
  force_vars = NULL,
  nfilter,
  ncomp = 5,
  scale_x = TRUE,
  type = c("index", "names", "full"),
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix of predictors}

\item{force_vars}{Vector of column names within \code{x} which are always retained
in the model (i.e. not filtered). Default \code{NULL} means all predictors will
be filtered.}

\item{nfilter}{Either a single value for the total number of predictors to
return. Or a vector of length \code{ncomp} to manually return predictors from
each PLS component.}

\item{ncomp}{the number of components to include in the PLS model.}

\item{scale_x}{Logical whether to scale predictors before fitting the PLS
model. This is recommended.}

\item{type}{Type of vector returned. Default "index" returns indices,
"names" returns predictor names, "full" returns a named vector of variable
importance.}

\item{...}{Other arguments passed to \code{\link[pls:mvr]{pls::plsr()}}}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters. If
\code{type} is \code{"full"} full output of coefficients from \code{plsr} is returned as a
list for each model component ordered by highest absolute coefficient.
}
\description{
Filter using coefficients from partial least squares (PLS) regression to
select optimal predictors.
}
\details{
The best predictors may overlap between components, so if \code{nfilter} is
specified as a vector, the total number of unique predictors returned may be
variable.
}
