% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeatcv.R
\name{repeatfolds}
\alias{repeatfolds}
\title{Create folds for repeated nested CV}
\usage{
repeatfolds(y, repeats = 5, n_outer_folds = 10)
}
\arguments{
\item{y}{Outcome vector}

\item{repeats}{Number of repeats}

\item{n_outer_folds}{Number of outer CV folds}
}
\value{
List containing indices of outer CV folds
}
\description{
Create folds for repeated nested CV
}
\examples{
\donttest{
data("iris")
dat <- iris
y <- dat$Species
x <- dat[, 1:4]

## set up fixed fold indices
set.seed(123, "L'Ecuyer-CMRG")
folds <- repeatfolds(y, repeats = 3, n_outer_folds = 4)

res <- nestcv.glmnet(y, x, family = "multinomial", alphaSet = 1,
                     n_outer_folds = 4, cv.cores = 2) |>
       repeatcv(3, repeat_folds = folds)
res
}
}
