% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netSEMp2.R
\name{netSEMp2}
\alias{netSEMp2}
\title{network Structural Equation Modelling (netSEM) - Principle 2}
\usage{
netSEMp2(
  x,
  exogenous = NULL,
  endogenous = NULL,
  str = FALSE,
  criterion = "AIC"
)
}
\arguments{
\item{x}{A dataframe. By default it considers all columns as exogenous variables, except the first column which stores the system endogenous variable.}

\item{exogenous, }{by default it consideres all columns as exogenous variables except column number 1, which is the main endogenous response.}

\item{endogenous}{A character string of the column name of the main endogenous OR a numeric number indexing the column of the main endogenous.}

\item{str}{A boolean, whether or not this is a 'strength' type problem.}

\item{criterion}{By default uses AIC to identify best model. Alternative choice is BIC.}
}
\value{
A list of the following items:

\itemize{
\item "res.print": A matrix. For each row, first column is the endogenous variable, second column is the exogenous variable, 
the other columns show corresponding summary information.
}
}
\description{
This function builds an netSEM model using principle 2.
}
\details{
Principle 2 resembles the multiple regression principle in the way multiple predictors are considered simultaneously. Specifically, the first-level predictors to the system level variable, such as, Time and unit level variables, acted on the system level variable collectively by an additive model. This collective additive model can be found with a generalized stepwise variable selection (using the stepAIC() function in R, which performs variable selection on the basis of AIC or BIC) and this proceeds iteratively.

Data is analysed first using Principle 1 to find the best models. If needed, transformations based on the best models are applied to the predictors. Starting from the system response variable, each variable is regressed on all other variables except for the system response in an additive multiple regression model, which is reduced by a stepwise selection using stepAIC(). Then, for each selected variable, fitted regression for 6 selected functional forms (8 if strength type problem) and pick the best.
}
\examples{
\dontrun{
# Using AIC criterion
data(acrylic)
ans <- netSEMp2(acrylic, criterion = "AIC")

# Using AIC criterion
ans <- netSEMp2(acrylic, criterion = "BIC")


# Using simulated data
 s <- runif(100,0,2)
m3 <- 1+2.5*s+rnorm(100,0,0.5)
m1 <- runif(100,1,4)
m2 <- -1-m1+m3+rnorm(100,0,0.3)
 y <- 2+2*exp(m1/3)+(m2-1)^2-m3+rnorm(100,0,0.5)
# Check the pairwise plot 
sim <- data.frame(cbind(y,s,m1,m2,m3))
pairs(sim)
ans <- netSEMp2(sim)

}
}
\seealso{
\link[netSEM]{netSEMp1}
}
