% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{sample_dclvm}
\alias{sample_dclvm}
\title{Sample from a DCLVM}
\usage{
sample_dclvm(z, lambda, theta, npairs = NULL)
}
\arguments{
\item{z}{a vector of cluster labels}

\item{lambda}{desired average degree of the network}

\item{theta}{degree parameter}

\item{npairs}{number of pairs of \eqn{\{z_i, z_j\}}}
}
\value{
Adjacency matrix of DCLVM
}
\description{
A DCLVM with \eqn{K} clusters has edges generated as
\deqn{
 	 E[\,A_{ij} \mid x, \theta\,] \;\propto\; \theta_i \theta_j e^{- \|x_i - x_j\|^2}
}
where \eqn{x_i = 2 e_{z_i} + w_i}, \eqn{e_k} is the \eqn{k}th basis vector of \eqn{R^d}, \eqn{w_i \sim N(0, I_d)},
and \eqn{\{z_i\} \subset [K]^n}. The proportionality constant is chosen such
that the overall network has expected average degree \eqn{\lambda}.
To calculate the scaling constant, we approximate \eqn{E[e^{- \|x_i - x_j\|^2}]}
for \eqn{i \neq j} by generating random \code{npairs} \eqn{\{z_i, z_j\}} and average over them.
}
\details{
Sample form a degree-corrected latent variable model with Gaussian kernel
}
