% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurovec.R, R/neurovol.R,
%   R/sparse_neurovec.R
\name{concat}
\alias{concat}
\alias{concat,NeuroVec,NeuroVol-method}
\alias{concat,NeuroVol,NeuroVec-method}
\alias{concat,NeuroVec,NeuroVec-method}
\alias{concat,ROIVec,ROIVec-method}
\alias{concat,DenseNeuroVol,missing-method}
\alias{concat,DenseNeuroVol,DenseNeuroVol-method}
\alias{concat,AbstractSparseNeuroVec,missing-method}
\alias{concat,SparseNeuroVec,SparseNeuroVec-method}
\title{Concatenate two objects in the time dimension}
\usage{
concat(x, y, ...)

\S4method{concat}{NeuroVec,NeuroVol}(x, y, ...)

\S4method{concat}{NeuroVol,NeuroVec}(x, y, ...)

\S4method{concat}{NeuroVec,NeuroVec}(x, y, ...)

\S4method{concat}{ROIVec,ROIVec}(x, y, ...)

\S4method{concat}{DenseNeuroVol,missing}(x, y, ...)

\S4method{concat}{DenseNeuroVol,DenseNeuroVol}(x, y, ...)

\S4method{concat}{AbstractSparseNeuroVec,missing}(x, y, ...)

\S4method{concat}{SparseNeuroVec,SparseNeuroVec}(x, y, ...)
}
\arguments{
\item{x}{the first object, typically \code{NeuroVol} or \code{NeuroVec}}

\item{y}{the second object, typically \code{NeuroVol} or \code{NeuroVec}}

\item{...}{additional objects}
}
\value{
A temporally concatenated object.
}
\description{
Concatenate two objects in the time dimension
}
\details{
The \code{x} and \code{y} images must have compatible dimensions. A \code{NeuroVol} can be concatenated to \code{NeuroVec}, and vice versa. See examples.
}
\note{
dimensions of x and y must be equal
}
\examples{
bv1 <- NeuroVol(rep(1,1000), NeuroSpace(c(10,10,10), c(1,1,1)))
bv2 <- NeuroVol(rep(2,1000), NeuroSpace(c(10,10,10), c(1,1,1)))
bv3 <- concat(bv1,bv2)
inherits(bv3, "NeuroVec")

bv4 <- concat(bv3, bv1)
dim(bv4)[4] == 3
bv5 <- concat(bv1, bv3)
dim(bv4)[4] == 3

bv6 <- concat(bv4,bv5)
dim(bv6)[4] == 6

}
