% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{nvd-plot}
\alias{nvd-plot}
\alias{autoplot.nvd}
\alias{plot.nvd}
\title{MDS Visualization of Network Distributions}
\usage{
\method{autoplot}{nvd}(object, memberships = rep(1, length(object)), method = "mds", ...)

\method{plot}{nvd}(x, method = "mds", ...)
}
\arguments{
\item{object, x}{A list containing two samples of network-valued data stored
as objects of class \code{\link{nvd}}.}

\item{memberships}{An integer vector specifying the membership of each
network to a specific sample. Defaults to \code{rep(1, length(nvd))} which
assumes that all networks in the input \code{\link{nvd}} object belong to a single
group.}

\item{method}{A string specifying which dimensionality reduction method to
use for projecting the samples into the cartesian plane. Choices are
\code{"mds"}, \code{"tsne"} or \code{"umap"}. Defaults to \code{"mds"}.}

\item{...}{Extra arguments to be passed to the plot function.}
}
\value{
Invisibly returns a \code{\link[ggplot2]{ggplot}} object. In
particular, the data set computed to generate the plot can be retrieved via
\verb{$data}. This is a \code{\link[tibble]{tibble}} containing the following
variables:
\itemize{
\item \code{V1}: the x-coordinate of each observation in the plane,
\item \code{V2}: the y-coordinate of each observation in the plane,
\item \code{Label}: the sample membership of each observation,
\item \code{Representation}: the type of matrix representation used to manipulate each
observation,
\item \code{Distance}: the distance used to measure how far each observation is from
the others.
}
}
\description{
This function generates 2-dimensional plots of samples of networks via
multi-dimensional scaling using all representations and distances included in
the package.
}
\examples{
gnp_params <- list(p = 1/3)
k_regular_params <- list(k = 8L)
x <- nvd(model = "gnp", n = 10L, model_params = gnp_params)
y <- nvd(model = "k_regular", n = 10L, model_params = k_regular_params)
mb <- c(rep(1, length(x)), rep(2, length(y)))
z <- as_nvd(c(x, y))
ggplot2::autoplot(z, memberships = mb)
plot(z, memberships = mb)
}
