% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/group.R
\docType{methods}
\name{is_assigned}
\alias{is_assigned}
\alias{is_assigned-method}
\alias{any_assigned}
\alias{any_assigned-method}
\alias{all_assigned}
\alias{is_assigned,ReferenceGroups-method}
\alias{any_assigned,ReferenceGroups-method}
\alias{all_assigned,ReferenceGroups-method}
\title{Grouped Data}
\usage{
is_assigned(object)

any_assigned(object)

all_assigned(object)

\S4method{is_assigned}{ReferenceGroups}(object)

\S4method{any_assigned}{ReferenceGroups}(object)

\S4method{all_assigned}{ReferenceGroups}(object)
}
\arguments{
\item{object}{A \link[=group]{grouped} \R object.}
}
\value{
\itemize{
\item \code{is_assigned()} returns a \code{\link{logical}} vector specifying whether or
not an observation belongs to a group.
\item \code{any_assigned()} returns an \code{\link{logical}} scalar specifying if any
observation belongs to a group.
\item \code{all_assigned()} returns an \code{\link{logical}} scalar specifying if all
observations belong to a group.
}
}
\description{
Retrieve the (reference) groups to which the observations belong.
}
\examples{
## Data from Aitchison 1986
data("slides")

## Coerce to compositional data
coda <- as_composition(slides, groups = 2)

## Grouping metadata
group_levels(coda)

group_names(coda)

group_indices(coda)

group_rows(coda)

group_n(coda)

group_size(coda)
}
\seealso{
Other grouping methods: 
\code{\link{group}()},
\code{\link{group_names}()},
\code{\link{group_split}()},
\code{\link{group_subset}()}
}
\author{
N. Frerebeau
}
\concept{grouping methods}
